//
//  MCMDispatch.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 09-10-22.
//  Copyright 2009 Marketcircle Inc. All rights reserved.
//

#import <MCServerSupport/MCCoreDataManager.h>


@class MCMMessage, MCMAccount;

extern NSString *kMCMDispatchFileExtension;

@interface MCMDispatch : MCCoreDataManager {

	MCMAccount *currentAccount;
}

- (MCMAccount *)currentAccount;
- (void)setCurrentAccount:(MCMAccount *)aCurrentAccount;

- (NSString *)accountNameForProcessName:(NSString *)processName;

- (NSArray *)unreadMessagesFrom:(NSString *)sender;
- (NSArray *)unreadMessages;

+ (MCMDispatch *)sharedDispatch;
+ (void)setSharedDispatch:(MCMDispatch *)dispatch;

+ (MCMDispatch *)createSharedDispatchWithStoreURL:(NSURL *)url;

@end
